<?php
/*--------------------------------------------------------------------
 Reader.php 2020-2-17
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Shop\SellingUnit\Database\Price\PropertyInformation\Repository\Readers;

use Doctrine\DBAL\Connection;
use Gambio\Shop\Product\ValueObjects\ProductId;
use Gambio\Shop\SellingUnit\Database\Price\PropertyInformation\Exceptions\ProductDoesNotHaveAnyCombinationsException;
use Gambio\Shop\SellingUnit\Database\Price\PropertyInformation\Repository\DTO\CombisIdDto;
use Gambio\Shop\SellingUnit\Database\Price\PropertyInformation\Repository\DTO\CombisIdDtoCollection;
use Gambio\Shop\SellingUnit\Database\Price\PropertyInformation\Repository\DTO\CombisValuesIdPropertyValuesIdDtoCollection;
use Gambio\Shop\SellingUnit\Database\Price\PropertyInformation\Repository\DTO\PricePlainDto;

/**
 * Class Reader
 * @package Gambio\Shop\SellingUnit\Database\Price\PropertyInformation\Repository\Readers
 */
class Reader implements ReaderInterface
{
    protected const COMBI_TABLE        = 'products_properties_combis';
    protected const COMBIS_ID_COLUMN   = 'products_properties_combis_id';
    protected const PRODUCTS_ID_COLUMN = 'products_id';
    
    /**
     * @var Connection
     */
    protected $connection;
    
    
    /**
     * Reader constructor.
     *
     * @param Connection $connection
     */
    public function __construct(Connection $connection)
    {
        $this->connection = $connection;
    }
    
    
    /**
     * @inheritDoc
     */
    public function availableCombisIds(ProductId $productId): CombisIdDtoCollection
    {
        $combisIdResult = $this->connection->createQueryBuilder()
            ->select(self::COMBIS_ID_COLUMN)
            ->from(self::COMBI_TABLE)
            ->where(self::PRODUCTS_ID_COLUMN . '=' . $productId->value())
            ->execute();
        
        if ($combisIdResult->rowCount() === 0) {
    
            throw new ProductDoesNotHaveAnyCombinationsException('Product with the id: ' . $productId->value()
                                                                 . ' does not have any combinations');
        }
    
        $result = new CombisIdDtoCollection;
        
        foreach ($combisIdResult->fetchAll() as $row) {
            
            $result[] = new CombisIdDto((int)$row[self::COMBIS_ID_COLUMN]);
        }
        
        return $result;
    }
}